:- module(argumentChoices,[selectArgument/3]).

:- use_module(library(lists)). 
:- use_module(library(random)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%% Choice of Argument to expand, takes a list (P or O) and returns the struct and the       %%%
%%% remainder of the list.								     %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

selectArgument(L,Struct,Rest)	:-
		user:argument_choice(X),
		selectArgument(X,L,Struct,Rest).

%%% simply pick from the from ... always trying to complete an argument
selectArgument(1,[H|Tail],H,Tail).

%%% ALTERNATIVE 2: always pick from the back, aiming to tackle newest challenges
selectArgument(2, ListIn, End, FrontTail)	:-
		append(FrontTail,[End],ListIn). 

%%% ALTERNATIVE 3: pick one at random from the list
selectArgument(3, List, Elem, Rest)	:-
		length(List,Length),
		Upper is Length + 1,
		random(1,Upper,RandomNum),
		nth(RandomNum,List,Elem),
		append(X,[Elem|Y],List),
		append(X,Y,Rest). 